<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Размещение изображения</title>
<style>
/* Стиль для контейнера */
.container {
    position: relative;
    width: 100%; /* Задайте нужную ширину контейнера */
    height: 100vh; /* Высота контейнера (можете изменить по необходимости) */
    border: 1px solid #ddd; /* Для наглядности граница контейнера */
}
/* Стиль для изображения */
.image {
    position: absolute; /* Не задавайте начальные значения top и left здесь */
    cursor: pointer; /* Курсор при наведении на изображение */
}
</style>
</head>
<body>
<div class="container" id="vse"> 
    <img src="ris2/pole(6x6).png" id="ris_pole" class="image" alt="Картинка"> 
</div>
<script>
let pole = [];
for (let i = 0; i < 6; i++) {
    pole[i] = [];
    for (let j = 0; j < 6; j++) {
        pole[i][j] = 0;
    }
}

let kol_sv = 0; // Кол. всех свечей
let sv_cvet = []; // Цвет свечи 0-красный, 1 - зеленый
let sv_razm = []; // Размер 2,3
let sv_x = []; // Коорд. x свечи        
let sv_y = []; // Коорд. y свечи                

kol_sv = 11;
sv_cvet[0] = 0; sv_razm[0] = 2; sv_x[0] = 0; sv_y[0] = 0;
sv_cvet[1] = 1; sv_razm[1] = 2; sv_x[1] = 1; sv_y[1] = 0;    
sv_cvet[2] = 0; sv_razm[2] = 3; sv_x[2] = 4; sv_y[2] = 0;    
sv_cvet[3] = 1; sv_razm[3] = 2; sv_x[3] = 2; sv_y[3] = 1;
sv_cvet[4] = 3; sv_razm[4] = 2; sv_x[4] = 0; sv_y[4] = 2;        
sv_cvet[5] = 0; sv_razm[5] = 2; sv_x[5] = 2; sv_y[5] = 2;        
sv_cvet[6] = 0; sv_razm[6] = 3; sv_x[6] = 5; sv_y[6] = 2;            
sv_cvet[7] = 1; sv_razm[7] = 2; sv_x[7] = 3; sv_y[7] = 3;            
sv_cvet[8] = 0; sv_razm[8] = 3; sv_x[8] = 0; sv_y[8] = 3;                
sv_cvet[9] = 1; sv_razm[9] = 2; sv_x[9] = 1; sv_y[9] = 4;
sv_cvet[10] = 0; sv_razm[10] = 2; sv_x[10] = 3; sv_y[10] = 4;                
sv_cvet[11] = 1; sv_razm[11] = 2; sv_x[11] = 4; sv_y[11] = 5;                

let div8 = document.getElementById('vse');

for (let i = 0; i <= kol_sv; i++) {
    let img1 = document.createElement("img");
    img1.setAttribute("id", "ris_" + i);
    img1.setAttribute("class", "image"); 
    img1.setAttribute("onmousedown", "vubor(event, id)");
    img1.setAttribute("onmousemove", "dvig(event, id)");
    img1.setAttribute("onmouseup", "na_pole(id)");
    
    let ris_src = "ris2/s_";
    if (sv_cvet[i] == 0) {
        ris_src = ris_src + "k_";
    } else {
        ris_src = ris_src + "z_";
    }
    ris_src += sv_razm[i] + ".png";
    
    if (sv_cvet[i] == 3) { ris_src = "ris2/klyh.png"; }
    
    let k_x = sv_x[i] * 50 + 6;
    let k_y = sv_y[i] * 50 + 6;
    
    img1.setAttribute("src", ris_src);
    img1.style.top = k_y + 'px';
    img1.style.left = k_x + "px";
    
    div8.appendChild(img1);

    for (let t = 0; t < sv_razm[i]; t++) {
        let k_x1 = sv_x[i];
        let k_y1 = sv_y[i];
        if (sv_cvet[i] == 0) {
            k_y1 += t;
        } else {
            k_x1 += t;
        }
        pole[k_y1][k_x1] = 1;
    }
}    

let nagata = "";
let draggingElement = null;
let offsetX = 0;
let offsetY = 0;

function vubor(event, id) {
    nagata = "da";
    draggingElement = document.getElementById(id);
    
    // Получаем координаты курсора относительно элемента
    const rect = draggingElement.getBoundingClientRect();
    offsetX = event.clientX - rect.left;
    offsetY = event.clientY - rect.top;
    
    //alert(offsetX+"x"+offsetY);
}

function dvig(event, id) {
    if (nagata === "") { return; }
    
    if (draggingElement) {
        // Вычисляем новые координаты
        const x = event.clientX - offsetX;
        const y = event.clientY - offsetY;
        
        // Устанавливаем новые координаты для изображения
        draggingElement.style.left = `${x}px`;
        draggingElement.style.top = `${y}px`;
    }
}

function na_pole(id) {
    nagata = "";
    draggingElement = null;
}</script>
</body>
</html>
